/*
   This program reads lines from standard input (stdin)
   and filters them to standard output (stdout) but this
   program first "redirects" its standard output to be
   a child process. This creates a simple, two stage
   pipeline made up of the parent and child processes.

   If standard input is the console keyboard,
   use ^z (Control-z) to denote the end of file
   (and you must use ^z at the beginning of a line!).

   Important: Notice how this program is similar to
   the following command line pipe.

   C:\> java RemoveVowels | java Double

   In the case of the above command line, the shell
   program (cmd.exe) sets up the I/O redirection
   (the pipe) before running the two programs
   RemoveVowels.class and Double.class. In the case
   of this program, this program itself does its own
   I/O redirection (setting up the pipe) between itself
   (which acts like RemoveVowels.java) and its child
   process before running the child process.
*/
import java.util.Scanner;
import java.io.*;

public class Java6_ParentChildPipeline_ver1
{
   public static void main(String[] args) throws IOException, InterruptedException
   {
      // Create a command line for running the filter.
      String cmd = "java Double";
      // Execute the filter.
      Process process = Runtime.getRuntime().exec(cmd);

      PrintStream myStdout = System.out;  // save the parent's output stream

      // Redirect System.out to be the standard input of the filter program
      // (this is the "pipeline" between the parent and the child).
      System.setOut( new PrintStream( process.getOutputStream() ) );

      // Create a Scanner object to make it easier to use System.in
      Scanner scanner = new Scanner( System.in );

      // Create a new stream to read data from the output of the filter.
      Scanner stdoutOfChild = new Scanner( process.getInputStream() );

      // Send all of the data from stdin to the next stage (the child).
      while ( scanner.hasNextLine() )
      {
         String oneLine = scanner.nextLine();  // read from stdin
         // Filter the line of input before
         // sending it to the next stage.
         for (int i = 0; i < oneLine.length(); i++)
         {
            if ( -1 == "aeiouAEIOU".indexOf( oneLine.charAt(i) ) )
               System.out.print( oneLine.charAt(i) ); // write to stdout
         }
         System.out.println();            // write to stdout (which is the next stage)
      }
      System.out.close(); //THIS IS IMPORTANT (without it the child will hang)

      // Now read all of the data out of the pipeline and send it
      // to the parent's original stdout (which we saved in line 36).
      while ( stdoutOfChild.hasNextLine() )
      {
         String oneLine = stdoutOfChild.nextLine(); // read from the pipeline
         myStdout.println( oneLine );               // write to original stdout
      }

      // Wait for the child to finish its work.
      process.waitFor();  // this throws InterruptedException
   }
}

/*
   IMPORTANT:
   This pipeline will hang, and never terminate,
   if the input file is too large.
*/